/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13; import java.util.Vector; 
import djbuch.kapitel_06.GC;
import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class DJAgentContext implements AgentContext {
	private Agent currentAgent;
	private Document docContext;
	private Database currentDB;
	private String effectiveUserName;

	public DJAgentContext(String user, Database db, Document doc) {
		docContext = doc;
		currentDB = db;
		effectiveUserName = user;
	}
	public DJAgentContext(String user, Database db, Document doc, Agent agent) {
		docContext = doc;
		currentDB = db;
		effectiveUserName = user;
		currentAgent = agent;
	}
	public String getEffectiveUserName() throws NotesException {
		return effectiveUserName;
	}
	public Database getCurrentDatabase() throws NotesException {
		return currentDB;
	}
	public Document getDocumentContext() throws NotesException {
		return docContext;
	}
	public Agent getCurrentAgent() throws NotesException {
		return currentAgent;
	}
	public void updateProcessedDoc(Document arg0) throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public DocumentCollection unprocessedFTSearch(String arg0, int arg1)
			throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public DocumentCollection unprocessedFTSearch(String arg0, int arg1,
			int arg2, int arg3) throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public DocumentCollection unprocessedSearch(String arg0, DateTime arg1,
			int arg2) throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public int getLastExitStatus() throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public DateTime getLastRun() throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public Document getSavedData() throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public DocumentCollection getUnprocessedDocuments() throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public void recycle(Vector arg0) throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public DocumentCollection unprocessedFTSearchRange(String arg0, int arg1,
			int arg2) throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public DocumentCollection unprocessedFTSearchRange(String arg0, int arg1,
			int arg2, int arg3, int arg4) throws NotesException {
		throw new NotesException(999, "not yet implemented.");
	}
	public void recycle() throws NotesException {
		docContext = GC.recycle (docContext);
		currentDB = GC.recycle(currentDB);
		currentAgent = GC.recycle(currentAgent);
	}
}